#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "mbed.h"
#include "S6D0151_TFT.h"
#include "Consolas10.h"
#include "Consolas12.h"
#include "Prototype33x38.h"
#include "Prototype29x28.h"
#include "aimasu_80x103.h"

S6D0151_TFT TFT(PTD2, PTD3, PTD1, PTA13, PTD5,"TFT"); // mosi, miso, sclk, cs, reset

//Serial pc(USBTX, USBRX); // tx, rx
Ticker tt;

void start_display(void);

int main() {

    TFT.claim(stdout);      // send stdout to the TFT display 
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white

    TFT.set_orientation( 0 );
    TFT.cls();
    TFT.locate(0,0);

    TFT.set_font((unsigned char*) Consolas7x13);  // select the font

    TFT.background(Black);    // set background to black
    TFT.foreground(Green);    // set chars to white
    
    start_display();            // 
    wait(3);

    TFT.set_font((unsigned char*) Consolas7x13);  // select the font

    while(1){
        TFT.set_orientation( 2 );
        TFT.background(White);
        TFT.cls();
        wait(0.5);
        TFT.foreground(Olive);
        TFT.Bitmap(  0,  0, 80,103,(unsigned char*)hibiki_80x103);
        TFT.foreground(Maroon);
        TFT.set_font((unsigned char*) Consolas7x13);  // select the font
        
        wait(3);
        TFT.set_orientation( 0 );
        TFT.background(Black);
        TFT.foreground(White);
        TFT.cls();
        TFT.locate(0,0);
        TFT.printf("TFT2P0327-E\n");
        TFT.printf("driver=S6D0151\n");
        
        TFT.locate(10,50);TFT.foreground(Cyan);
        TFT.printf("TEST!!");
        TFT.locate(15,62);
        TFT.set_font((unsigned char *)Prototype29x28);
        TFT.printf("mbed");TFT.foreground(Magenta);
        TFT.locate(5,90);
        TFT.set_font((unsigned char*) Consolas9x16);  // select the font
        TFT.printf("FRDM-KL2Z");TFT.foreground(GreenYellow);
        
        wait(3);
        // draw some graphics
        TFT.cls();
        TFT.set_font((unsigned char*) Consolas7x13);
        TFT.locate(5,5);
        TFT.printf("Graphic");

        TFT.line(0,0,100,0,Green);
        TFT.line(0,0,0,150,Green);
        TFT.line(0,0,100,150,Green);

        TFT.rect(50,100,100,150,Red);
        TFT.fillrect(30,25,80,70,Blue);

        TFT.circle(40,50,10,White);
        TFT.fillcircle2(50,60,8,Yellow);

        double s;

        for (int i=0; i<128; i++) {
            s =20 * sin((long double) i / 10 );
            TFT.pixel(i,100 + (int)s ,Red);
        }
        wait(3);
    } // for while()
   
}


void start_display(){
    TFT.cls();
    TFT.foreground(Green);
    TFT.background(Black);
    TFT.set_font((unsigned char*) Prototype33x38);
    TFT.locate( 48,  5);
    TFT._putc(135); // TAKA
    TFT.locate( 14, 38);
    for(char i=136;i<139;i++)TFT._putc(i); // BO C CHI
    TFT.locate( 14, 76);
    for(char i=139;i<142;i++)TFT._putc(i); // TAN KEN TAI
}

